#ifndef BOOK_H
#define BOOK_H

#include <vector>
#include <list>
#include <string>
#include <fstream>

#include "move.h"
#include "defs.h"
#include "board.h"
#include "material.h"
#include "movelist.h"
#include "history.h"

using namespace std;

struct SBookOptions {
    string pgnfile;
    int plydepth;
    string outfile;
    string existingbook;
    int setout;
    int setexist;
    int countmoves;
    int addtobook; // 0 means making new book, 1 means adding to a book
};

struct S_bookentry {
    u64 key;
    int move;
    int count;
    int win;
    int loss;
};

class cBookmake {

    private:
    vector<S_bookentry> booklines;
    cMovelist mlist;
    cBoard pboard;
    cMaterial mat;
    cHistory his;


    void readbook();
    void readlist(list<S_bookentry> &list);
    void getbookoptions();
    bool makesan(const string make);
    void writebook(list<S_bookentry> &bookentries);
    void addentry(list<S_bookentry> &l, const S_bookentry &temp);

    public:
    cBookmake();
    void readpgn();
    SBookOptions bookoptions; //lazy  public :)

};

class cBookread {

    private:
    string bookname;
    ifstream bookfile;
    bool fileexists;
    vector<S_bookentry> whitemoves;
    vector<S_bookentry> blackmoves;


     cBookread( const cBookread & );
         cBookread &operator = ( const cBookread & );


    public:

    cBookread();

    bool bookmove(u64 key, uint &move);
    bool usingbook() { return fileexists; }
    void setbookuse(bool use);
    void init_book(); //set fileexists and read in book to the vectors
    void setbookname(string name) {bookname = name;}

};




#endif

